<?php $__env->startSection('title', translate('Login_Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/system-setting.png')); ?>" alt="">
                <?php echo e(translate('Customer_Login_Settings')); ?>

            </h2>
        </div>
        <?php echo $__env->make('admin-views.system-setup.login-settings.partials.login-settings-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form action="<?php echo e(route('admin.system-setup.login-settings.customer-login-setup')); ?>" method="post"
              enctype="multipart/form-data" id="customer-login-setup-update">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header">
                    <div>
                        <h4 class="mb-1">
                            <?php echo e(translate('Setup_Login_Option')); ?>

                        </h4>
                        <p class="fs-12 m-0">
                            <?php echo e(translate('the_option_you_select_customer_will_have_the_to_option_to_login')); ?>

                        </p>
                    </div>
                </div>
                <div class="card-body pt-3">
                    <form>
                        <div class="row g-3 mb-4">
                            <div class="col-sm-6 col-md-4">
                                <label class="form-check form--check form--check--inline border rounded">
                                    <span class="user-select-none form-check-label flex-grow-1">
                                        <?php echo e(translate('Manual_Login')); ?>

                                        <span data-toggle="tooltip" data-placement="top"
                                              title="<?php echo e(translate('by_enabling_manual_login_customers_will_get_the_option_to_create_account_and_log_in_using_necessary_credentials_and_password_in_the_app_and_website')); ?>">
                                            <i class="tio-info-outined"></i>
                                        </span>
                                    </span>
                                    <input class="form-check-input login-option-type" type="checkbox"
                                           name="manual_login"
                                           id="customer-manual-login"
                                           value="1"
                                        <?php echo e($loginOptions['manual_login'] ? 'checked' : ''); ?>

                                    >
                                </label>
                            </div>
                            <div class="col-sm-6 col-md-4">
                                <label class="form-check form--check form--check--inline border rounded">
                                    <span class="user-select-none form-check-label flex-grow-1">
                                        <?php echo e(translate('OTP_Login')); ?>

                                        <span data-toggle="tooltip" data-placement="top"
                                              title="<?php echo e(translate('with_otp_login_customers_can_log_in_using_their_phone_number.')); ?> <?php echo e(translate('while_new_customers_can_create_accounts_instantly')); ?>">
                                            <i class="tio-info-outined"></i>
                                        </span>
                                    </span>
                                    <input type="checkbox"
                                           name="otp_login"
                                           id="customer-otp-login"
                                           value="1"
                                           class="form-check-input social-media-status-checkbox"
                                           data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                           data-key="otp-login"
                                        <?php echo e($loginOptions['otp_login'] ? 'checked' : ''); ?>

                                    >
                                </label>
                            </div>
                            <div class="col-sm-6 col-md-4">
                                <label class="form-check form--check form--check--inline border rounded">
                                    <span class="user-select-none form-check-label flex-grow-1">
                                        <?php echo e(translate('Social_Media_Login')); ?>

                                        <span data-toggle="tooltip" data-placement="top"
                                              title="<?php echo e(translate('with_social_login_customers_can_log_in_using_social_media_credentials.')); ?> <?php echo e(translate('while_new_customers_can_create_accounts_instantly.')); ?>">
                                            <i class="tio-info-outined"></i>
                                        </span>
                                    </span>
                                    <input class="form-check-input login-option-type" type="checkbox"
                                           name="social_login"
                                           id="customer-social-login"
                                           value="1"
                                        <?php echo e($loginOptions['social_login'] ? 'checked' : ''); ?>

                                    >
                                </label>
                            </div>
                        </div>

                        <div class="mb-4 social-media-login-container <?php echo e($loginOptions['social_login'] ? '' : 'd--none'); ?>">
                            <div class="mb-3">
                                <h4 class="mb-1">
                                    <?php echo e(translate('social_media_login_setup')); ?>

                                </h4>
                                <a href="<?php echo e(route('admin.social-login.view')); ?>" class="fs-12 c1 text-underline fw-semibold" target="_blank">
                                    <?php echo e(translate('connect_3rd_party_login_system_from_here')); ?>

                                </a>
                            </div>
                            <div class="bg-light p-4 rounded">
                                <h4 class="mb-1">
                                    <?php echo e(translate('choose_social_media')); ?>

                                </h4>
                                <div class="row g-3">
                                    <div class="col-sm-6 col-md-4">
                                        <label class="form-check form--check form--check--inline border rounded">
                                            <span class="user-select-none form-check-label flex-grow-1">
                                                <?php echo e(translate('Google')); ?>

                                                <span data-toggle="tooltip" data-placement="top"
                                                      title="<?php echo e(translate('enabling_google_login_customers_can_log_in_to_the_site_using_their_existing_gmail_credentials.')); ?>">
                                                    <i class="tio-info-outined"></i>
                                                </span>
                                            </span>
                                            <input type="checkbox"
                                                   name="google_login"
                                                   data-status="<?php echo e($configStatus['google'] ? 'true' : 'false'); ?>"
                                                   id="google_login"
                                                   value="1"
                                                   class="form-check-input social-media-status-checkbox"
                                                   data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                                   data-key="google"
                                                <?php echo e($socialMediaLoginOptions['google'] ? 'checked' : ''); ?>

                                            >
                                        </label>
                                    </div>
                                    <div class="col-sm-6 col-md-4">
                                        <label class="form-check form--check form--check--inline border rounded">
                                            <span class="user-select-none form-check-label flex-grow-1">
                                                <?php echo e(translate('Facebook')); ?>

                                                <span data-toggle="tooltip" data-placement="top"
                                                      title="<?php echo e(translate('enabling_facebook_login_customers_can_log_in_to_the_site_using_their_existing_facebook_credentials.')); ?>">
                                                    <i class="tio-info-outined"></i>
                                                </span>
                                            </span>
                                            <input type="checkbox"
                                                   name="facebook_login"
                                                   data-status="<?php echo e($configStatus['facebook'] ? 'true' : 'false'); ?>"
                                                   id="facebook_login"
                                                   value="1"
                                                   class="form-check-input social-media-status-checkbox"
                                                   data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                                   data-key="facebook"
                                                <?php echo e($socialMediaLoginOptions['facebook'] ? 'checked' : ''); ?>

                                            >
                                        </label>
                                    </div>
                                    <div class="col-sm-6 col-md-4">
                                        <label class="form-check form--check form--check--inline border rounded">
                                            <span class="user-select-none form-check-label flex-grow-1">
                                                <?php echo e(translate('Apple')); ?>

                                                <span data-toggle="tooltip" data-placement="top"
                                                      title="<?php echo e(translate('enabling_apple_login_customers_can_log_in_to_the_site_using_their_existing_apple_login_credentials.')); ?>">
                                                    <i class="tio-info-outined"></i>
                                                </span>
                                            </span>
                                            <input type="checkbox"
                                                   name="apple_login"
                                                   data-status="<?php echo e($configStatus['apple'] ? 'true' : 'false'); ?>"
                                                   id="apple_login"
                                                   value="1"
                                                   class="form-check-input social-media-status-checkbox"
                                                   data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                                   data-key="apple"
                                                <?php echo e($socialMediaLoginOptions['apple'] ? 'checked' : ''); ?>

                                            >
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-4">
                            <div class="mb-3">
                                <h4 class="mb-1">
                                    <?php echo e(translate('OTP_Verification')); ?>

                                </h4>
                                <p class="fs-12">
                                    <?php echo e(translate('the_option_you_select_will_need_to_be_verified_by_the_customer')); ?>

                                </p>
                            </div>
                            <div class="bg-light p-4 rounded">
                                <div class="row g-3">
                                    <div class="col-sm-6 col-md-4">
                                        <label class="form-check form--check form--check--inline border rounded">
                                            <span class="user-select-none form-check-label flex-grow-1">
                                                <?php echo e(translate('Email_Verification')); ?>

                                                <span data-toggle="tooltip" data-placement="top"
                                                      title="<?php echo e(translate('if_email_verification_is_on_customers_must_verify_their_email_address_with_an_otp_to_complete_the_signup_process')); ?>">
                                                    <i class="tio-info-outined"></i>
                                                </span>
                                            </span>
                                            <input type="checkbox"
                                                   name="email_verification"
                                                   value="1"
                                                   class="form-check-input social-media-status-checkbox <?php echo e(env('APP_MODE') != 'demo' ? '' : 'call-demo'); ?>"
                                                   data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                                   data-key="email"
                                                <?php echo e(env('APP_MODE') != 'demo' ? '' : 'disabled'); ?>

                                                <?php echo e($emailVerification ? 'checked' : ''); ?>

                                            >
                                        </label>
                                    </div>
                                    <div class="col-sm-6 col-md-4">
                                        <label class="form-check form--check form--check--inline border rounded">
                                            <span class="user-select-none form-check-label flex-grow-1">
                                                <?php echo e(translate('Phone_Number_Verification')); ?>

                                                <span data-toggle="tooltip" data-placement="top"
                                                      title="<?php echo e(translate('if_phone_number_verification_is_on_customers_must_verify_their_phone_number_with_an_otp_to_complete_the_signup_process')); ?>">
                                                    <i class="tio-info-outined"></i>
                                                </span>
                                            </span>
                                            <input type="checkbox"
                                                    name="phone_verification"
                                                   id="phone_verification"
                                                   value="1"
                                                   class="form-check-input social-media-status-checkbox <?php echo e(env('APP_MODE') != 'demo' ? '' : 'call-demo'); ?>"
                                                   data-route="<?php echo e(route('admin.system-setup.login-settings.config-status-validation')); ?>"
                                                   data-key="otp"
                                                <?php echo e(env('APP_MODE') != 'demo' ? '' : 'disabled'); ?>

                                                <?php echo e($phoneVerification ? 'checked' : ''); ?>

                                            >
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="btn--container">
                            <button type="reset" class="btn btn-secondary"><?php echo e(translate('Reset')); ?></button>
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('Submit')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </form>
    </div>

    <div class="modal fade" id="customerLoginConfigValidation" tabindex="-1" aria-labelledby="toggle-modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content shadow-lg">
                <div class="modal-header border-0 pb-0 d-flex justify-content-end">
                    <button type="button" class="btn-close border-0" data-dismiss="modal" aria-label="Close">
                        <i class="tio-clear"></i>
                    </button>
                </div>
                <div class="modal-body px-4 px-sm-5 pt-0">

                </div>
            </div>
        </div>
    </div>

    <span id="customer-login-setup-validation-msg"
          data-title="<?php echo e(translate("no_login_option_selected")); ?>!"
          data-text="<?php echo e(translate("please_select_at_least_one_login_option.")); ?>"
          data-ok="<?php echo e(translate("ok")); ?>"
    ></span>
    <span class="select-google-or-facebook"
          data-text="<?php echo e(translate("please_select_at_least_one_between_Google_or_Facebook.")); ?>"
          data-text-two="<?php echo e(translate("please_select_at_least_one_between_Google_or_Facebook_or_Apple.")); ?>"
    ></span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/admin/customer-login-setup.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/sixvelly.nexprism.com/resources/views/admin-views/system-setup/login-settings/customer-login-setup.blade.php ENDPATH**/ ?>